/* Step 3: Create the procedure that loads the report table with your metrics. */
Create PROCEDURE [dbo].[up_report_load]
as
-- Clear the report file
delete report_values
-- Setup variables
declare @as_this_year varchar(4)
declare @as_last_year varchar(4)
declare @ai_month numeric
declare @push_list_string varchar(20)
declare @as_metric_one_string varchar(20)
-- Start setting month and date values
set @ai_month = Month( GetDate() )
set @as_this_year = Cast( Year( GetDate() ) as varchar(4) )
set @as_last_year = Cast( ( Year( GetDate() ) - 1 ) as varchar(4) )
/* Metric One Section -- repeat this section for each stored procedure that loads a metric for you */
-- Metric One this year
exec up_report_display_value_metric_one @ai_month, @as_this_year , @as_metric_one_string output 
-- Load the value to the report row
insert into report_values( report_field , report_value )
values ( 'metric_one_this_year', @as_metric_one_string )
-- Metric One last year
exec up_report_display_value_metric_one @ai_month, @as_last_year , @as_metric_one_string output 
-- Load the value to the report row
insert into report_values( report_field , report_value )
values ( 'metric_one_last_year', @as_metric_one_string )
-- Set the report_in_mil column
/* Note - If you do not want to display your data in millions, 
just copy the report_value straight over to report_in_mil */
-- I want in millions
update report_values
set report_in_mil = Convert( varchar(20), ( Cast( report_value as money )/1000000 ), 1) 

-- I want the real number
--update report_values
--set report_in_mil = report_value
